const mongoose = require('mongoose');
const User = require('./models/admin/User');
require('dotenv').config();

async function updateAdminEmail() {
  try {
    await mongoose.connect(process.env.MONGODB_URI || 'mongodb://localhost:27017/edumetrix', {
      useNewUrlParser: true,
      useUnifiedTopology: true,
    });

    // Update admin user to use the OTP-enabled email
    const result = await User.updateOne(
      { userType: 'admin', username: 'kaarysathan' },
      { 
        $set: { 
          'profile.email': 'edumetrixuk@gmail.com',
          username: 'edumetrixuk@gmail.com' // Also update username to match email
        }
      }
    );

    if (result.matchedCount > 0) {
      console.log('✅ Admin user updated successfully');
      console.log('📧 Admin email: edumetrixuk@gmail.com');
      console.log('🔐 Login method: OTP verification only');
    } else {
      console.log('❌ Admin user not found');
    }

    await mongoose.disconnect();
    process.exit(0);
  } catch (error) {
    console.error('Error updating admin:', error);
    process.exit(1);
  }
}

updateAdminEmail();