#!/bin/bash

echo "🟢 Starting Teacher Portal Only"
echo "==============================="

# Start backend if not running
if ! pgrep -f "node server.js" > /dev/null; then
    echo "🔧 Starting Backend Server..."
    node server.js > server.log 2>&1 &
    sleep 3
fi

# Start Teacher Portal
echo "🟢 Starting Teacher Portal (Port 3002)..."
cd client
PORT=3002 REACT_APP_PORTAL_TYPE=teacher npm start

# Open browser
if command -v open &> /dev/null; then
    sleep 3
    open http://localhost:3002
fi