import mongoose from 'mongoose';

const studentSchema = new mongoose.Schema({
  userId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'User',
    required: true
  },
  studentName: {
    type: String,
    required: true
  },
  parentName: {
    type: String,
    required: true
  },
  email: {
    type: String,
    required: true
  },
  phoneNumber: {
    countryCode: {
      type: String,
      required: true
    },
    number: {
      type: String,
      required: true
    }
  },
  profilePicture: {
    type: String,
    default: null
  },
  profilePictureType: {
    type: String,
    default: null
  },
  profilePictureFilename: {
    type: String,
    default: null
  },
  hourlyRate: {
    type: Number,
    required: true
  },
  currency: {
    type: String,
    enum: ['USD', 'GBP', 'AED', 'INR'],
    required: true
  },
  country: {
    type: String,
    enum: ['UAE', 'Saudi Arabia', 'Qatar', 'Kuwait', 'Bahrain', 'Oman', 'India', 'UK', 'Australia', 'New Zealand'],
    required: true
  },
  timezone: {
    type: String,
    default: function() {
      // Map country to timezone
      const countryTimezoneMap = {
        'UAE': 'Asia/Dubai',
        'Saudi Arabia': 'Asia/Riyadh',
        'Qatar': 'Asia/Qatar',
        'Kuwait': 'Asia/Kuwait',
        'Bahrain': 'Asia/Bahrain',
        'Oman': 'Asia/Muscat',
        'India': 'Asia/Kolkata',
        'UK': 'Europe/London',
        'Australia': 'Australia/Sydney',
        'New Zealand': 'Pacific/Auckland'
      };
      return countryTimezoneMap[this.country] || 'UTC';
    }
  },
  syllabus: {
    type: String,
    required: true
  },
  class: {
    type: String,
    enum: ['Class 1', 'Class 2', 'Class 3', 'Class 4', 'Class 5', 'Class 6', 'Class 7', 'Class 8', 'Class 9', 'Class 10', 'Class 11', 'Class 12', 'Class 13'],
    required: true
  },
  subjects: [{
    type: String,
    enum: ['Mathematics', 'General Science', 'Physics', 'Chemistry', 'Biology', 'English', 'Hindi', 'Computer Science', 'Arabic', 'Social Science', 'Geography', 'Malayalam']
  }],
  googleMeetLink: {
    type: String,
    default: null
  },
  assignedTeachers: [{
    teacherId: {
      type: mongoose.Schema.Types.ObjectId,
      ref: 'Teacher'
    },
    subject: {
      type: String,
      enum: ['Mathematics', 'General Science', 'Physics', 'Chemistry', 'Biology', 'English', 'Hindi', 'Computer Science', 'Arabic', 'Social Science', 'Geography', 'Malayalam']
    }
  }],
  isActive: {
    type: Boolean,
    default: true
  },
  isDeleted: {
    type: Boolean,
    default: false
  },
  deletedAt: {
    type: Date,
    default: null
  },
  // Store original password for admin access (encrypted)
  originalPassword: {
    type: String,
    default: null
  }
}, {
  timestamps: true
});

export default mongoose.model('Student', studentSchema);