import mongoose from 'mongoose';

const trialRequestSchema = new mongoose.Schema({
  studentName: {
    type: String,
    required: true
  },
  parentName: {
    type: String,
    required: true
  },
  email: {
    type: String,
    required: true
  },
  phoneNumber: {
    countryCode: {
      type: String,
      required: true
    },
    number: {
      type: String,
      required: true
    }
  },
  country: {
    type: String,
    enum: ['UAE', 'Saudi Arabia', 'Qatar', 'Kuwait', 'Bahrain', 'Oman', 'India', 'UK', 'Australia', 'New Zealand'],
    required: true
  },
  syllabus: {
    type: String,
    required: true
  },
  class: {
    type: String,
    enum: ['Class 1', 'Class 2', 'Class 3', 'Class 4', 'Class 5', 'Class 6', 'Class 7', 'Class 8', 'Class 9', 'Class 10', 'Class 11', 'Class 12', 'Class 13'],
    required: true
  },
  subjects: [{
    type: String,
    enum: ['Mathematics', 'General Science', 'Physics', 'Chemistry', 'Biology', 'English', 'Hindi', 'Computer Science', 'Arabic', 'Social Science', 'Geography', 'Malayalam']
  }],
  preferredTime: {
    type: String,
    default: null
  },
  preferredDays: [{
    type: String,
    enum: ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday']
  }],
  additionalNotes: {
    type: String,
    default: null
  },
  status: {
    type: String,
    enum: ['pending', 'scheduled', 'completed', 'cancelled', 'converted'],
    default: 'pending'
  },
  source: {
    type: String,
    enum: ['website', 'manual'],
    required: true
  },
  scheduledDate: {
    type: Date,
    default: null
  },
  assignedTeacher: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Teacher',
    default: null
  },
  trialClassLink: {
    type: String,
    default: null
  },
  convertedAt: {
    type: Date,
    default: null
  },
  convertedToStudentId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'Student',
    default: null
  }
}, {
  timestamps: true
});

// Clear any cached model
if (mongoose.models.TrialRequest) {
  delete mongoose.models.TrialRequest;
}

export default mongoose.model('TrialRequest', trialRequestSchema);