const mongoose = require('mongoose');
const bcrypt = require('bcryptjs');
const User = require('./models/admin/User');
require('dotenv').config();

async function fixAdminLogin() {
  try {
    await mongoose.connect(process.env.MONGODB_URI || 'mongodb://localhost:27017/edumetrix', {
      useNewUrlParser: true,
      useUnifiedTopology: true,
    });


    // Remove existing admin user if exists
    await User.deleteOne({ username: 'admin@edumetrix.uk' });

    // Create fresh admin user
    const hashedPassword = await bcrypt.hash('admin123', 10);
    
    const adminUser = new User({
      username: 'admin@edumetrix.uk',
      password: hashedPassword,
      userType: 'admin',
      profile: {
        name: 'System Administrator',
        email: 'admin@edumetrix.uk',
        position: 'System Administrator',
        department: 'Administration',
        profilePicture: null
      },
      isActive: true,
      isDeleted: false
    });

    await adminUser.save();
    
    // Verify the user was created correctly
    const createdUser = await User.findOne({ username: 'admin@edumetrix.uk' });
    
    // Test password
    const passwordMatch = await bcrypt.compare('admin123', createdUser.password);
    
    
    process.exit(0);
  } catch (error) {
    console.error('❌ Error fixing admin login:', error);
    process.exit(1);
  }
}

fixAdminLogin();