const mongoose = require('mongoose');
const bcrypt = require('bcryptjs');
const User = require('./models/admin/User');
const Student = require('./models/student/Student');
const Teacher = require('./models/teacher/Teacher');
require('dotenv').config();

async function createTestUsers() {
  try {
    await mongoose.connect(process.env.MONGODB_URI || 'mongodb://localhost:27017/edumetrix', {
      useNewUrlParser: true,
      useUnifiedTopology: true,
    });


    // Create Teacher User
    const existingTeacher = await User.findOne({ username: 'teacher@edumetrix.uk' });
    if (!existingTeacher) {
      const hashedTeacherPassword = await bcrypt.hash('teacher123', 10);
      
      const teacherUser = new User({
        username: 'teacher@edumetrix.uk',
        password: hashedTeacherPassword,
        userType: 'teacher',
        isActive: true,
        isDeleted: false
      });

      await teacherUser.save();
      
      // Create teacher profile
      const teacherProfile = new Teacher({
        userId: teacherUser._id,
        name: 'Test Teacher',
        email: 'teacher@edumetrix.uk',
        subjects: ['Mathematics', 'Physics'],
        qualifications: ['BSc Mathematics', 'MSc Physics'],
        experience: '5 years',
        isActive: true
      });

      await teacherProfile.save();
    } else {
    }

    // Create Student User
    const existingStudent = await User.findOne({ username: 'student@edumetrix.uk' });
    if (!existingStudent) {
      const hashedStudentPassword = await bcrypt.hash('student123', 10);
      
      const studentUser = new User({
        username: 'student@edumetrix.uk',
        password: hashedStudentPassword,
        userType: 'student',
        isActive: true,
        isDeleted: false
      });

      await studentUser.save();
      
      // Create student profile
      const studentProfile = new Student({
        userId: studentUser._id,
        studentName: 'Test Student',
        email: 'student@edumetrix.uk',
        grade: '10th Grade',
        subjects: ['Mathematics', 'Physics'],
        guardianName: 'Test Guardian',
        guardianPhone: '+44 123 456 7890',
        isActive: true
      });

      await studentProfile.save();
    } else {
    }

    
    process.exit(0);
  } catch (error) {
    console.error('Error creating test users:', error);
    process.exit(1);
  }
}

createTestUsers();