const mongoose = require('mongoose');
const Student = require('./models/student/Student');
const User = require('./models/admin/User');
require('dotenv').config();

async function checkStudents() {
  try {
    await mongoose.connect(process.env.MONGODB_URI || 'mongodb://localhost:27017/edumetrix', {
      useNewUrlParser: true,
      useUnifiedTopology: true,
    });

    console.log('\n=== Database Check ===\n');
    
    // Count all students
    const totalStudents = await Student.countDocuments();
    console.log('Total students in database:', totalStudents);
    
    // Count active, non-deleted students (what dashboard shows)
    const activeStudents = await Student.countDocuments({ isActive: true, isDeleted: false });
    console.log('Active students (shown in dashboard):', activeStudents);
    
    // List recent students
    console.log('\nRecent students (last 5):');
    const recentStudents = await Student.find()
      .sort({ createdAt: -1 })
      .limit(5)
      .populate('userId', 'username');
    
    recentStudents.forEach((student, index) => {
      console.log(`\n${index + 1}. ${student.studentName}`);
      console.log(`   Email: ${student.email}`);
      console.log(`   Created: ${student.createdAt}`);
      console.log(`   Active: ${student.isActive}`);
      console.log(`   Deleted: ${student.isDeleted}`);
      console.log(`   Username: ${student.userId?.username || 'N/A'}`);
    });
    
    // Check admin user
    console.log('\n=== Admin User Check ===');
    const adminUser = await User.findOne({ username: 'admin@edumetrix.uk' });
    if (adminUser) {
      console.log('Admin user found:', adminUser._id);
      console.log('Admin active:', adminUser.isActive);
    } else {
      console.log('Admin user NOT found!');
    }
    
    process.exit(0);
  } catch (error) {
    console.error('Error:', error);
    process.exit(1);
  }
}

checkStudents();